program operation_list;
{$mode objfpc}{$H+}
uses
  CRT, FileUtil;
type
  PMyList = ^TMyList;
  TMyList = record
  data: integer;
  next: PMyList;
  end;
var
  pHead, pCurrent: PMyList;
  Elem, choose: integer;
procedure view_MyList (pHead: PMyList);
var
  p: PMyList;
begin
  if pHead = nil then exit;
  p:= pHead;
  writeln(p^.data);
  if p^.next = nil then
    exit
  else
  p:= p^.next;
    view_MyList(p);
end;

procedure Insert_MyList(Elem: integer; var pHead, pCurrent: PMyList);
{pHead - указатель на первый элемент списка ("голову" списка
 p Current - указатель на текущий элемент списка}
var
  p: PMyList; // рабочий указатель
begin
  new(p);  // заводим новый элемент
  p^.data:= Elem; // записываем в него данные
  {Если список был пустой, то головой списка становится p}
  if pHead = nil then
  begin
    p^.next:= nil;
    pHead:= p;
  end
  else
  begin
    p^.next:= pCurrent^.next; { в новом элементе делаем ссылку
    на следующий элемент, который был до вставки}
    pCurrent^.next:= p; { в текущем элементе делаем ссылку на новый}
  end;
  pCurrent:= p; // текущим становится новый элемент
end;

function Search_MyList(Elem: integer; var pHead: PMyList): boolean;
var
  p: PMyList;
begin
  if pHead <> nil then
    p:=pHead
  else
  begin
    writeln(UTF8ToConsole('Список пуст'));
    exit;
  end;
  Search_MyList:= false;
  while true do
  begin
    if p^.data = Elem then
    begin
      Search_MyList:= true;
      break;
    end
    else
    if p^.next = nil  then break;
    p:= p^.next;
  end;
end;

procedure Delete_MyList(Elem: integer; var pHead, pCurrent: PMyList);
var
  p: PMyList;
  pPrev: PMyList; // предыдущий элемент списка
  find: boolean;
begin
   if pHead <> nil then
    p:=pHead
  else
  begin
    writeln(UTF8ToConsole('Список пуст'));
    exit;
  end;
  find:= false;
  while true do
  begin
    if p^.data = Elem then
    begin
      find:= true;
      break;
    end
    else
    if p^.next = nil  then break;
    pPrev:= p;
    p:= p^.next;
  end;
  if find then
  begin
    if p=pHead then // если удаляется первый элемент
    begin
      p:= pHead^.next; // запоминаем ссылку на следующий элемент
      Dispose(pHead);  // удаляем первый элемент списка
      pHead:= p;       // головой списка становится p
    end
    else
    begin  // если удаляется не первый элемент
      pPrev^.next:= p^.next; { в предыдущем элементе заменяем
      ссылку на следующий элемент после удаляемого }
      Dispose(p);
      pCurrent:=pPrev; // текущим делаем предыдущий элемент
    end;
    writeln(UTF8ToConsole('Элемент успешно удален'));
  end
  else writeln(UTF8ToConsole('Элемент не найден'));
end;
begin
  pHead:= nil;
  pCurrent:= nil;
  repeat
    writeln(UTF8ToConsole('Выберите нужное действие:'));
    writeln(UTF8ToConsole('1-ввод элемента списка'));
    writeln(UTF8ToConsole('2-поиск элемента списка'));
    writeln(UTF8ToConsole('3-удаление элемента списка'));
    writeln(UTF8ToConsole('4-просмотр всего списка'));
    writeln(UTF8ToConsole('5-выход из программы'));
    readln(choose);
    case choose of
    1: begin {ввод элемента списка}
         writeln(UTF8ToConsole('Введите элемент списка'));
         readln(Elem);
         Insert_MyList(Elem, pHead, pCurrent);
       end;
    2: begin {поиск элемента списка}
         writeln(UTF8ToConsole('введите искомый элемент'));
         readln(Elem);
         if Search_MyList(Elem, pHead)then
           writeln(UTF8ToConsole('Элемент найден'))
         else
           writeln(UTF8ToConsole('Элемент не найден'));
       end;
    3: begin {удаление элемента списка}
         writeln(UTF8ToConsole('введите элемент'));
         readln(Elem);
         Delete_MyList(Elem, pHead, pCurrent);
       end;
    4: begin {Вывод списка на экран}
         writeln(UTF8ToConsole('Элементы списка:'));
         writeln;
         view_MyList (pHead);
         writeln;
       end;
     end; { end of case }
  until choose=5;
  writeln(UTF8ToConsole('Нажмите любую клавишу'));
  readkey;
end.

